/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.VWConfigBaseNode;
import filenet.vw.toolkit.admin.resources.VWResource;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class VWConfigStatusTableModel
extends AbstractTableModel {
    public static final int CategoryColumn = 0;
    public static final int NameColumn = 1;
    public static final int ServiceColumn = 2;
    public static final int RegionColumn = 3;
    public static final int WorkItemsColumn = 4;
    public static final int DataColumn = 5;
    public static final String CATEGORY_SYSTEM_PROPERTY = VWResource.SystemProperties;
    public static final String CATEGORY_REGION_PROPERTY = VWResource.IsolatedRegionProperties;
    public static final String CATEGORY_SERVER_PROPERTY = VWResource.ServerProperties;
    public static final String CATEGORY_EVENTLOG_PROPERTY = VWResource.EventLogProperties;
    public static final String CATEGORY_QUEUE_PROPERTY = VWResource.QueueProperties;
    public static final String CATEGORY_ROSTER_PROPERTY = VWResource.RosterProperties;
    public static final String CATEGORY_NEW_QUEUE = VWResource.NewQueue;
    public static final String CATEGORY_NEW_ROSTER = VWResource.NewRoster;
    public static final String CATEGORY_NEW_EVENTLOG = VWResource.NewEventLog;
    public static final String CATEGORY_IMPORT_REGION = VWResource.ImportRegion;
    public static final String CATEGORY_NEW_APPSPACE = VWResource.NewApplicationSpace;
    public static final String CATEGORY_APPSPACE_PROPERTY = VWResource.ApplicationSpaceProperties;
    private static final int COLUMN_CATEGORY = 0;
    private static final int COLUMN_NAME = 1;
    private static final int COLUMN_SERVICE = 2;
    private static final int COLUMN_REGION = 3;
    private static final int COLUMN_WORKITEMS = 4;
    private boolean m_bShowWorkItems = false;
    private Vector m_rowData = null;

    public VWConfigStatusTableModel(Vector rawData, boolean bShowWorkItems) {
        this.m_bShowWorkItems = bShowWorkItems;
        this.m_rowData = rawData;
    }

    public void removeRow(int nRowIndex) {
        this.m_rowData.removeElementAt(nRowIndex);
        this.fireTableRowsDeleted(nRowIndex, nRowIndex);
    }

    public void addRow(Object obj) {
        this.m_rowData.addElement(obj);
        int rowIndex = this.m_rowData.size() - 1;
        this.fireTableRowsInserted(rowIndex, rowIndex);
    }

    public void clearAll() {
        this.m_rowData.removeAllElements();
        this.fireTableDataChanged();
    }

    public VWConfigBaseNode getRowItemAt(int nRowIndex) {
        if (this.m_rowData == null || nRowIndex < 0 || nRowIndex > this.m_rowData.size()) {
            return null;
        }
        if (nRowIndex < this.m_rowData.size()) {
            return (VWConfigBaseNode)this.m_rowData.elementAt(nRowIndex);
        }
        return null;
    }

    public void releaseResources() {
        if (this.m_rowData != null) {
            this.m_rowData.removeAllElements();
            this.m_rowData = null;
        }
    }

    public Class getColumnClass(int nColumnIndex) {
        return String.class;
    }

    public int getColumnCount() {
        if (this.m_bShowWorkItems) {
            return 5;
        }
        return 4;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return VWResource.Category;
            }
            case 1: {
                return VWResource.Name;
            }
            case 2: {
                return VWResource.VWService;
            }
            case 3: {
                return VWResource.IsolatedRegion;
            }
            case 4: {
                return VWResource.WorkItemsAffected;
            }
        }
        return null;
    }

    public int getRowCount() {
        if (this.m_rowData != null && this.m_rowData.size() > 0) {
            return this.m_rowData.size();
        }
        return 1;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        block10: {
            try {
                VWConfigBaseNode aNode = this.getRowItemAt(nRowIndex);
                if (aNode != null) {
                    switch (nColumnIndex) {
                        case 0: {
                            return this.getChangeEvent(aNode);
                        }
                        case 1: {
                            return aNode.getName();
                        }
                        case 2: {
                            return aNode.getServiceName();
                        }
                        case 3: {
                            return aNode.getRegionIDString();
                        }
                        case 4: {
                            int count = aNode.getWorkItemsAffected();
                            return String.valueOf(count);
                        }
                    }
                    break block10;
                }
                return new String();
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        return false;
    }

    private String getChangeEvent(VWConfigBaseNode aNode) {
        switch (aNode.getChangeEventStatus()) {
            case 3: {
                return CATEGORY_SYSTEM_PROPERTY;
            }
            case 4: {
                return CATEGORY_REGION_PROPERTY;
            }
            case 5: {
                return CATEGORY_SERVER_PROPERTY;
            }
            case 6: {
                return CATEGORY_EVENTLOG_PROPERTY;
            }
            case 7: {
                return CATEGORY_QUEUE_PROPERTY;
            }
            case 8: {
                return CATEGORY_ROSTER_PROPERTY;
            }
            case 9: {
                return CATEGORY_NEW_QUEUE;
            }
            case 10: {
                return CATEGORY_NEW_ROSTER;
            }
            case 11: {
                return CATEGORY_NEW_EVENTLOG;
            }
            case 12: {
                return CATEGORY_IMPORT_REGION;
            }
            case 13: {
                return CATEGORY_NEW_APPSPACE;
            }
            case 14: {
                return CATEGORY_APPSPACE_PROPERTY;
            }
        }
        return new String();
    }
}

